@extends('layouts.app')

@section('content')
    <!-- Page Header -->
    <div class="py-8 sm:py-12 md:py-16 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center">
                <h1 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-900 mb-4">Status Pembayaran</h1>
                <p class="text-lg sm:text-xl text-gray-600">Informasi status pembayaran dan instruksi selanjutnya</p>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 sm:py-12 md:py-16 bg-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-lg">
                    <div class="p-6 text-gray-900">
                    <div class="mb-6">
                        <h3 class="text-lg font-medium text-gray-900">Detail Pendaftaran</h3>
                        <div class="mt-2 grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <p class="text-sm text-gray-600">No. Registrasi:</p>
                                <p class="font-medium">{{ $registration->registration_number }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Nama Pasien:</p>
                                <p class="font-medium">{{ $registration->patient->name }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Tanggal Pemeriksaan:</p>
                                <p class="font-medium">{{ $registration->exam_date->format('d/m/Y') }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Jenis Pemeriksaan:</p>
                                <p class="font-medium">{{ ucfirst($registration->exam_type) }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Patient Portal Access Information -->
                    <div class="mb-6 p-4 bg-blue-50 border border-blue-200 ">
                        <h3 class="text-lg font-medium text-blue-900 mb-4">Akses Portal Pasien</h3>
                        <div class="p-3 bg-blue-100 ">
                            <p class="text-sm text-blue-800">
                                <strong>Informasi Penting:</strong> MRN dan password untuk akses portal pasien akan diberikan oleh admin setelah pembayaran dikonfirmasi. 
                                Anda akan menerima email dengan informasi login tersebut.
                            </p>
                        </div>
                        <div class="mt-4">
                            <a href="{{ route('results.patient.form') }}" 
                               class="inline-flex items-center px-4 py-2 bg-[#192D50] text-white text-sm font-medium  hover:bg-blue-700 transition duration-150">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                </svg>
                                Portal Pasien
                            </a>
                        </div>
                    </div>

                    @if($payment)
                        <div class="bg-gray-50 p-4 ">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Detail Pembayaran</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <p class="text-sm text-gray-600">No. Virtual Account:</p>
                                    <p class="font-medium text-lg">{{ $payment->va_number }}</p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-600">Jumlah:</p>
                                    <p class="font-medium text-lg">Rp {{ number_format($payment->amount, 0, ',', '.') }}</p>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-600">Status:</p>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                        @if($payment->status == 'paid') bg-green-100 text-green-800
                                        @elseif($payment->status == 'pending') bg-yellow-100 text-yellow-800
                                        @elseif($payment->status == 'failed') bg-red-100 text-red-800
                                        @else bg-gray-100 text-gray-800 @endif">
                                        {{ ucfirst($payment->status) }}
                                    </span>
                                </div>
                                @if($payment->paid_at)
                                    <div>
                                        <p class="text-sm text-gray-600">Tanggal Bayar:</p>
                                        <p class="font-medium">{{ $payment->paid_at->format('d/m/Y H:i') }}</p>
                                    </div>
                                @endif
                            </div>

                            @if($payment->status == 'pending')
                                <div class="mt-6 p-4 bg-blue-50 border border-blue-200 ">
                                    <h4 class="font-medium text-blue-900">Instruksi Pembayaran:</h4>
                                    <ol class="mt-2 text-sm text-blue-800 list-decimal list-inside space-y-1">
                                        <li>Transfer ke Virtual Account: <strong>{{ $payment->va_number }}</strong></li>
                                        <li>Jumlah: <strong>Rp {{ number_format($payment->amount, 0, ',', '.') }}</strong></li>
                                        <li>Pembayaran akan diproses otomatis setelah transfer</li>
                                        <li>Anda akan menerima notifikasi email setelah pembayaran berhasil</li>
                                    </ol>
                                </div>
                            @elseif($payment->status == 'paid')
                                <div class="mt-6 p-4 bg-green-50 border border-green-200 ">
                                    <h4 class="font-medium text-green-900">Pembayaran Berhasil!</h4>
                                    <p class="mt-2 text-sm text-green-800">
                                        Terima kasih! Pembayaran Anda telah berhasil diproses. 
                                        Silakan datang pada tanggal yang telah ditentukan untuk pemeriksaan.
                                    </p>
                                </div>
                            @endif
                        </div>
                    @else
                        <div class="bg-red-50 p-4 ">
                            <h3 class="text-lg font-medium text-red-900">Pembayaran Tidak Ditemukan</h3>
                            <p class="mt-2 text-sm text-red-800">
                                Data pembayaran untuk registrasi ini tidak ditemukan. 
                                Silakan hubungi administrator.
                            </p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
